# import discovery
from . import port

def discover_port(var, data):
    # pylint: disable=unused-argument
    return "discover"

def get_port(var, database):
    # Add handling for port not existing
    return database.get_port_data(var)

def add_port(var, data):
    # pylint: disable=unused-argument
    newPort = port.Port(port_id=var)
    return newPort.formatted_data()

def edit_port(var, data):
    """
    Check new port data struct is valid. Checking of actual contents will be done
    in the database.
    Temporary - should parse/check in here
    """
    # pylint: disable=unused-argument
    return data

def check_route(route, method):
    """
    Check whether a route exists in the database and seperartes the variable
    component from the actual path to parse into the function call of said path.
    """
    if method == "POST":
        routes = routes_POST
    else:
        routes = routes_GET
    part_route = ''
    if route in routes:
        return True, route, ''
    part_route = route.rpartition('/')[0] + '/{var}'
    if part_route in routes:
        return True, part_route, route.rpartition('/')[-1]
    return False, None, None


# This is where the API routes are definied
routes_GET = {
    '/' : {'handler': 'Big Brain Time!\n'},
    '/ports' : {'handler': 'Specify a port\n'},
    '/ports/{var}' : {'handler': 'Port specified!\n'},
    '/ports/get/{var}' : {'handler': get_port}
}

routes_POST = {
    '/ports/add/{var}' : {'handler': add_port},
    '/ports/edit/{var}' : {'handler': edit_port},
    '/ports/discover/{var}' : {'handler': discover_port}
}