"""
ipaccess_cfg handles global IPAccess configuration (as opposed to node-specific config),
backed by a JSON file in the storage API.
"""
import copy

import yaml
from central_sdi import storage_api

key = 'ipaccess_cfg'
defaults = {
    'disable': False,
    'disable_routes': False,
    'route_metric': 1,
    'compress': False,
    'enable_wan': False,
    'enable_network_access_policies': False,
}


def default(cfg):
    """
    Apply defaults to global IPAccess config
    """
    return copy.deepcopy({**defaults, **cfg})


def load():
    """
    Fetch global IPAccess config
    """
    try:
        return yaml.safe_load(storage_api.sa_load(key))
    except storage_api.ObjectNotFound:
        return {}


def store(cfg):
    """
    Update global IPAccess config
    """
    storage_api.sa_store(key, yaml.dump({**cfg}))
