
import falcon.status_codes as http_status
import os

from central_sdi import openvpn, sessions


class ClientStatus:
    """Information about OpenVPN client sessions
    """

    def on_get(self, request, response):  # pylint: disable=unused-argument
        """IP Access status GET endpoint.
        ---
        description: Get IP Access client connection status
        responses:
            200:
                description: List of connected clients
                content:
                    application/json:
                        schema: Status
        """
        resp = []
        cache = sessions.Cache(cache_dir=os.environ.get("CACHE_DIR"))
        for client in openvpn.OpenVPNManager().get_client_status():
            # Fetch connection cache for this client
            connection = cache.load(client.connected_since_unix)
            if not connection:
                # This connection isn't in the cache, which means something weird has happened
                continue

            resp.append({
                "node_id": connection.node_id,
                "node_name": connection.node_name,
                "username": connection.username,
                "common_name": client.common_name,
                "real_address": client.real_address,
                "virtual_address": client.virtual_ipv4_address,
                "bytes_received": client.bytes_rec,
                "bytes_sent": client.bytes_sent,
                "connected_since": client.connected_since,
                "client_id": client.client_id,
            })

        response.media = {"status": resp}
        response.status = http_status.HTTP_200
