"""
SDI API router
"""
from central_sdi.api import ipaccess, certs, status, policies
from netops import (
    auth as nom_auth
)
from typing import (
    Optional
)


class Root:
    """
    Root wires the api business logic up
    """
    def __init__(
            self,
            nom_auth_stub: Optional[nom_auth.AdapterStub] = None,
    ):
        """
        constructs a new root
        """
        self._routes = {
            "/routes": {'handler': ipaccess.Routes(nom_auth_stub)},
            "/rights": {'handler': ipaccess.Rights()},
            "/status": {'handler': status.ClientStatus()},
            "/ipaccess": {'handler': ipaccess.IPAccess()},
            "/nodes": {'handler': ipaccess.IPAccessNodes()},
            "/nodes/actions": {'handler': ipaccess.IPAccessNodesActions()},
            "/certs": {'handler': certs.Certs()},
            "/certs/config": {'handler': certs.Config()},
            "/certs/{serial}": {'handler': certs.Cert()},
            "/certs/{serial}/export": {'handler': certs.Export()},
            "/policies": {'handler': policies.Policies()},
        }

    @property
    def routes(self):
        """
        routes describes the falcon api resources keyed on their path
        """
        return self._routes

    def register_routes(self, api):
        """
        Add routes to the api
        """
        for route, properties in self._routes.items():
            handler = properties.get('handler')
            api.add_route(route, handler)

    def auth_required(self, endpoint):
        if endpoint not in self._routes:
            # Should never reach this
            return False

        return not self._routes.get(endpoint).get("no_auth")
