import asyncio
from concurrent import futures
from typing import Dict
from central_ag import storage_api
from central_ag.api import schema
from netops import (
    automation_gateway as ag,
)

devices_names_key = 'devices_names'
_schema = schema.DeviceNameList(
    partial=True,
)


def store(devices_names: Dict):
    """
    Update devices' names
    """
    storage_api.sa_store(devices_names_key, _schema.dumps(devices_names))


def load() -> Dict:
    """
    Load and return all devices' names, note that the backing data will be validated
    against the schema, excepting missing fields (potentially a gotcha in the
    migration case)
    """
    try:
        return _schema.loads(storage_api.sa_load(devices_names_key).read())
    except storage_api.ObjectNotFound:
        return _schema.load({})
    except ValueError:
        return _schema.load({})


class AIO:
    """TODO real asyncio"""

    def __init__(self, executor: futures.Executor):
        self._executor = executor

    async def load(self) -> ag.Manual.MacName:
        data = {}
        for v in (await asyncio.get_event_loop().run_in_executor(self._executor, load)).get('devices_names', []):
            data[v['mac']] = v['name']
        return ag.Manual.MacName(data=data)
