#!/usr/bin/env bash

# USAGE:
# update_authorized_keys.sh CMD ARGS...
#
# Updates /srv/authorized_keys with stdout from a given command, if that
# command succeeds.

[ "$#" -gt 0 ] \
&& f="$( mktemp )" \
|| exit 1

chown git: -- "$f" \
&& chmod 640 -- "$f" \
&& "$@" >"$f" \
&& mv -- "$f" /srv/authorized_keys \
&& exit 0

rm -f -- "$f"
exit 1
