#!/bin/bash

# WARNING the stdout AND stderr of this script is shown on the client performing the push

set -o pipefail || exit 1

# Redirect stdout and stderr of this script to a subshell running an append tee for
# deploy.log, so it's logged to here as well as stdout.
exec &> >( syslog.sh )

workspace="$1"
workspaceSource="http://dop-storage-api/${workspace}/"
workspaceTarget="/srv/central-ui/${workspace}"

[ ! -z "${workspace}" ] \
    && rclone -q sync --http-url "$workspaceSource" :http: "$workspaceTarget" \
    && mkdir -p "$workspaceTarget"/scripts "$workspaceTarget"/downloads \
    && rm -rf "/srv/central-ui/.resources_unsynchronised_${workspace}" \
    && exit 0

echo "Deploy failed, unable to sync workspace $workspace."
exit 1
