#!/bin/bash

# export ngcs system info as newline-delimited key=base64_value

set -eo pipefail || exit 1

system_interfaces=( $( ls /sys/class/net/ ) )

system_macs=""
for system_interface in "${system_interfaces[@]}"; do
    system_mac="$( base64 -w 0 < /sys/class/net/"$system_interface"/address )" || system_mac=""
    system_macs="${system_macs}${system_interface}=${system_mac}"$'\n'
done
unset system_interface system_mac

ethtool_interfaces=""
for system_interface in "${system_interfaces[@]}"; do
    ethtool_interface="$( ethtool "$system_interface" | base64 -w 0 )" || ethtool_interface=""
    ethtool_interfaces="${ethtool_interfaces}${system_interface}=${ethtool_interface}"$'\n'
done
unset system_interface ethtool_interface

iflinks=""
for system_interface in "${system_interfaces[@]}"; do
    iflink="$(eval 'echo $(cat /sys/class/net/${system_interface}/ifindex),$(cat /sys/class/net/${system_interface}/iflink) | base64 -w 0')"
    iflinks="${iflinks}${system_interface}=${iflink}"$'\n'
done

system_interfaces="${system_interfaces[*]}"

for key in \
    system_interfaces \
    system_macs \
    ethtool_interfaces \
    iflinks
do
    value="$( eval 'echo -n "$'"$key"'" | base64 -w 0' )"
    echo "${key}=${value}"
done
unset value
