#!/bin/bash

# Must be run in the same directory as the Python package

# Add Python location to paths
if ! grep -q "NetOps Modules" /etc/config/profile; then
    cat << EOF >> /etc/config/profile
# Automatically generated by NetOps Modules
export PATH="\$PATH:/var/opt/python/bin"
export PYTHONPATH="/var/opt/python"
export PYTHONHOME="/var/opt/python"
export LD_LIBRARY_PATH="/var/opt/lib:$LD_LIBRARY_PATH"
EOF
fi
source /etc/config/profile

if ! grep -q "NetOps Modules" /etc/config/rc.local; then
    mntpoint=$(config -g config.services.tftp.directory | awk '{ print $2 }' | sed 's:/tftpboot$::')
    [[ -z "$mntpoint" ]] && mntpoint=/var/mnt/storage.usb
    cat << EOF >> /etc/config/rc.local
# Automatically generated by NetOps Modules
[[ ! -d $mntpoint/var/opt ]] && mkdir -p $mntpoint/var/opt
[[ ! -L /var/opt ]] && ln -s $mntpoint/var/opt /var/opt
EOF
fi
/etc/config/rc.local

rm -rf /var/opt/* && tar -xvzf python_ogcs.tar.gz -C /