#!/usr/bin/env bash

set -eo pipefail || exit 1

ssh-keygen -A > /dev/null

mkdir -p \
    /etc/ansible \
    /srv/central \
    /srv/central-auto/downloads \
    /srv/central-auto/scripts \
    /srv/central-ui

touch \
    /var/log/deploy.log \
    /etc/firewall-post \
    /srv/authorized_keys

chown git: /srv/authorized_keys
chmod 640 /srv/authorized_keys

cp /root/.netops/ansible.cfg /etc/ansible/

# entrypoint environment is cached at /tmp/env for cli / git deploys, should support multi-line values
# it uses bash -c for the actual saving bit to avoid picking up rando bash variables
( umask 177 \
    && filePath="$( mktemp )" \
    && bash -c 'for key in \
        PATH \
        "${!APP_@}" \
        "${!LH_@}" \
        "${!ANSIBLE_@}" \
    ; do value="$( printenv "$key" )" && value="$( printf %q "$value" )" && echo "export $key=$value" || exit 1; done' > "$filePath" \
    && chmod 600 "$filePath" \
    && mv "$filePath" /tmp/env \
    && exit 0 \
    || rm -f "$filePath" \
    && exit 1 )

# Initialize central git repo for ZTP resources
pushd /srv/central > /dev/null
git init --bare > /dev/null
( umask 177 \
    && filePath="$( mktemp )" \
    && echo $'#!/bin/sh\nexec sudo -n /etc/scripts/post_receive.sh' > "$filePath" \
    && chmod 555 "$filePath" \
    && mv "$filePath" hooks/post-receive \
    && exit 0 \
    || rm -f "$filePath" \
    && exit 1 )
chown -R git: .
popd > /dev/null

# Initialize autocommit repo
pushd /srv/central-auto > /dev/null
git init > /dev/null
git remote add origin /srv/central &> /dev/null || git remote set-url origin /srv/central > /dev/null
popd > /dev/null

## Write any firewall rules required to the post-firewall script, overwriting any
# of the existing container rules.
START_DELIM="# GENERATED BY central-dop START"
END_DELIM="# GENERATED BY central-dop END"

# Delete any existing rules for this container.
firewallRules="$( remove_file_content \
	--start="$START_DELIM" \
	--end="$END_DELIM" \
	--file=/etc/firewall-post )"
echo "$firewallRules" > /etc/firewall-post

# Apply the (new) firewall rules.
{ echo "$START_DELIM" && find /etc/firewall-post.d -type f -exec cat {} + && echo "$END_DELIM" ; } >> /etc/firewall-post

# attempt to sync the authorized keys file from the storage api
update_authorized_keys.sh python3 -c 'from central_dop.api import dop; print("\n".join([key["public_key"] for key in dop.load_keys_file()]))'

# Continue with container start.
exec -- "$@"
