import argparse
import netmiko

desc = \
    "This is a basic CLI for injecting configs or commands directly \
    via the specified serial connection."

arg_parser = argparse.ArgumentParser(description=desc,
    fromfile_prefix_chars='@')
arg_parser_req = arg_parser.add_argument_group("Required arguments")

arg_parser_req.add_argument('-d', '--device',
    help='device Type (e.g. cisco_ios_pmshell)')
arg_parser_req.add_argument('-p', '--port',
    help='port descriptor (e.g. /dev/ttyS0)')
arg_parser.add_argument('-c', '--command',
    help='string to pipe to device serial')
arg_parser.add_argument('-f', '--file',
    help='path to file containing config')

def gen_device(device_type, port):
    device = {
        "device_type": device_type,
        "serial_settings": {
            "port": port
        }
    }
    return device

def check_args(arg_parser):
    args = arg_parser.parse_args()
    try:
        args.device
        args.port
    except AttributeError as e:
        arg_parser.print_help()
        exit("\n\nERROR: Missing device or port argument(s)")
    if (not args.command) and (not args.file):
        arg_parser.print_help()
        exit("\n\nERROR: Missing command or config file argument")
    return args

if __name__ == "__main__":
    args = check_args(arg_parser)
    device = gen_device(args.device, args.port)
    conn = netmiko.ConnectHandler(**device)
    conn.enable()
    if args.file:
        conn.read_config_from_file(args.file)
    elif args.command:
        conn.send_command(args.command)
    conn.disconnect()
