"""
file_serve provides helper functions for the TFTP and HTTP file servers
"""
import os


def get_filename_to_serve(filename, serve_dir='/tftpboot'):
    """
    get_filename_to_serve: returns the basename of a file without the .j2
    extension if it has one. Otherwise just returns the filename as is.
    """
    filename_to_serve = None
    j2_filename = "{}.j2".format(filename)
    if os.path.exists('{}/{}'.format(serve_dir, j2_filename)):
        filename_to_serve = j2_filename
    elif os.path.exists('{}/{}'.format(serve_dir, filename)):
        filename_to_serve = filename

    return filename_to_serve


def serve_file(start_response, file_path, chunk_size=1000000):
    """
    serve_file: serves a file for uwsgi using a chunked streaming-compatible implementation

    :param start_response: the closure passed into the application def (uwsgi)
    :param file_path: path to the file to serve
    :param chunk_size: the max size of each chunk, in bytes
    :return: a generator of bytearray
    """
    try:
        with open(file_path, 'rb') as file:
            start_response('200 OK', [('Content-Type', 'application/octet-stream'), ('Content-Length', str(os.path.getsize(file.name)))])
            while True:
                buffer = file.read(chunk_size)
                if not buffer:
                    break
                yield buffer
    except OSError:
        start_response('404 Not found', [])
