"""
firewall implements specific logic and behavior for configuration of the many different firewalls
the secure provisioning module needs to deal with
"""

from netops.ngcs import client, logic, models

# remote_lan_service models all the ports required in the lan zone
remote_lan_service = models.FirewallService(
    {
        "name": "nom-dop-lan",
        "label": "NetOps Secure Provisioning Module - LAN",
        "ports": [
            {"protocol": "tcp", "port": 80},  # http
            {"protocol": "udp", "port": 69},  # tftp
            {"protocol": "udp", "port": 123},  # ntp
            {"protocol": "udp", "port": 514},  # syslog
            {"protocol": "tcp", "port": 53},  # dns
            {"protocol": "udp", "port": 53},  # dns
        ]
    },
)

# remote_lhvpn_service models all the ports required in the lan zone
remote_lhvpn_service = models.FirewallService(
    {
        "name": "nom-dop-lhvpn",
        "label": "NetOps Secure Provisioning Module - LHVPN",
        "ports": [
            {"protocol": "tcp", "port": 2222},  # ssh (remote-dop)
        ]
    },
)


def configure_remote(api: client.Api):
    """
    configures a ngcs node's firewall by adding rules to allow the required services on
    specific services
    """
    # create / update necessary services
    api.update_firewall_service(remote_lan_service)
    api.update_firewall_service(remote_lhvpn_service)

    # add services to zones via rules (if necessary)
    lan_zone = logic.find_firewall_zone(api.get_firewall_zones(), name='lan')
    try:
        logic.find_firewall_rule(api.get_firewall_rules(), service=remote_lan_service.name, zone=lan_zone.id)
    except logic.NotFoundException:
        api.post_firewall_rule(models.FirewallRule({'service': remote_lan_service.name, 'zone': lan_zone.id}))
