"""
api: initialises the Falcon rest api, basically wrapping the other setup classes.
"""
import falcon
from central_dop.api import auth
from central_dop.api import authz
from central_dop.api import errors
from central_dop.api import router


class AuthenticationMiddleware:
    def process_resource(self, request, response, resource, params):  # pylint: disable=unused-argument
        """
        process_resource: Called after routing has occured but before handler
        is called.
        """
        # Auth required
        if router.auth_required(request.uri_template):
            scheme, token = auth.get_http_authorization(request)
            if scheme == "Cert":
                # Cert auth is not implemented yet
                raise errors.Forbidden(error="Permission denied")

            if token is None:
                raise errors.Forbidden(error="Permission denied")

            request.context["token"] = token
            secctxt = authz.secctxt_from_token(token)
            request.context["secctxt"] = secctxt

            if not authz.can(token, "/nom/dop" + request.path, request.method):
                raise errors.Forbidden(error="Permission denied")


app = application = falcon.App(middleware=AuthenticationMiddleware())

router.register_routes(app)
app.add_error_handler(falcon.HTTPNotFound, errors.not_found)
app.add_error_handler(falcon.HTTPMethodNotAllowed, errors.not_supported)
