from typing import Dict
from central_ag import storage_api
from central_ag.api import schema

devices_redirects_key = 'devices_redirects'
_schema = schema.DeviceRedirectList(
    partial=True,
)


def store(devices_redirects: Dict):
    """
    Update devices' routes
    """
    storage_api.sa_store(devices_redirects_key, _schema.dumps(devices_redirects))


def load() -> Dict:
    """
    Load and return all devices' routes, note that the backing data will be validated
    against the schema, excepting missing fields (potentially a gotcha in the
    migration case)
    """
    try:
        return _schema.loads(storage_api.sa_load(devices_redirects_key).read())
    except storage_api.ObjectNotFound:
        return _schema.load({})
    except ValueError:
        return _schema.load({})
