"""
auth implements authentication and authorization
"""

class Identity:
    """
    Identity is a high level implementation common between Middleware and the actual router
    """


class Middleware:
    """
    Middleware implements authentication middleware usable by falcon
    """

    def __init__(self, identity: Identity):
        self._identity = identity

    def process_resource(self, request, response, resource, params):  # pylint: disable=unused-argument
        """
        process_resource is called for every api request
        """
        token = get_http_authorization(request)
        request.context["token"] = token


def get_http_authorization(request):
    """ Get the session token from the header and validate
    """
    if request.auth is None:
        return None

    auth_hdr_components = request.auth.strip().split(' ')
    if len(auth_hdr_components) != 2 or auth_hdr_components[0] != 'Token':
        return None

    return auth_hdr_components[1]
