import asyncio
from . import manage

class BigBrain:
    """
    The overarching object which serves to start and contain the worker threads.
    """
    def __init__(self, host_port, host_addr):
        self.tasks = []
        self.threads = []
        self.database = []
        self.host_port = host_port
        self.host_addr = host_addr
        self.job_queue = asyncio.Queue()
        self.data_queue = asyncio.Queue()
        self.loop = asyncio.get_event_loop()
        self.threads.append(self.start_database_manager())
        self.threads.append(self.start_thread_manager(idx=0))
        self.threads.append(self.start_request_manager(idx=0,
            thread=self.threads[0]))
        for thread in self.threads:
            self.tasks.append(thread.task)
        self.loop.run_until_complete(asyncio.gather(*self.tasks))

    def start_database_manager(self):
        return manage.DatabaseManager(self.data_queue, self.loop, self.database)

    def start_thread_manager(self, idx):
        return manage.ThreadManager(idx, self.job_queue, self.data_queue, self.loop)

    def start_request_manager(self, idx, thread):
        return manage.RequestManager(idx, self.job_queue, self.loop, self.host_addr,
            self.host_port, thread)
