"""
Custom Media type Handlers need to be added to Falcon to handle requests
other than application/json
References:
1. https://falcon.readthedocs.io/en/stable/api/media.html#
"""
from falcon.media import BaseHandler


class PLAINTEXTHandler(BaseHandler):
    """Handler for handling content type text/plain"""

    def serialize(self, media, content_type):  # pylint: disable=unused-argument
        """encode the data
        """
        if not isinstance(media, bytes):
            return media.encode('utf-8')
        return media

    def deserialize(self, stream, content_type, content_length):  # pylint: disable=unused-argument
        """decode the data
        """
        try:
            return stream.decode('utf-8')
        except UnicodeError:
            return stream

class ZipHandler(BaseHandler):
    """Handler for handling content type application/zip"""
    def serialize(self, media, content_type):  # pylint: disable=unused-argument
        return media

    def deserialize(self, stream, content_type, content_length):  # pylint: disable=unused-argument
        return stream
