"""
logger can be used across the API to log anything to /var/log/central_dop_api.log.
To use the logger:
    from central_dop.api import logger
    log = logger.set_up_logging()'
    log.info("my_message")
    log.error("my_bad_message")
"""

import logging
import logging.handlers
import tempfile

NAME = "central_dop_api"

def set_up_logging():
    """ initialise the logger with some default log settings """

    log_filename = "/var/log/{}.log".format(NAME)
    try:
        with open(log_filename, 'a+'):
            pass
    except PermissionError:
        # Create a temp file instead of using the system log directory. This will
        # happen when running on a system where /var/log/ is not writeable by
        # the current user.
        _, f_name = tempfile.mkstemp(prefix=NAME)
        log_filename = "{}.log".format(f_name)
        with open(log_filename, 'a+'):
            pass

    logger = logging.getLogger(NAME)
    log_fmt = '[%(asctime)s][%(levelname)s][%(pathname)s:%(lineno)d] -- %(message)s'
    logging.basicConfig(format=log_fmt, filemode='a+', filename=log_filename, level=logging.DEBUG)

    return logger
