#!/usr/bin/env bash

set -o pipefail

die() { echo FATAL "$@" >&2; exit 1; }

# Check the existence of required env vars
for k in \
    STORAGE_API_ADDR
do
    [ ! -z "${!k}" ] || die "$k not set"
done

# Configure auth key
load_code="$(curl --connect-timeout 5 -m 10 -s -o /tmp/key -w "%{http_code}" "$STORAGE_API_ADDR/auth_private_key")"
case "$load_code" in
    200)
        key="$(cat /tmp/key)"
        export AUTH_PRIVATE_KEY="$key"
        rm /tmp/key
        ;;
    404)
        # Key doesn't exist in storage API, generate one
        key="$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 128 | head -n 1)"
        save_code="$(curl --connect-timeout 5 -m 10 -X POST -s -w "%{http_code}" -d "$key" "$STORAGE_API_ADDR/auth_private_key")"
        case "$save_code" in
            200)
                export AUTH_PRIVATE_KEY="$key"
                ;;
            *)
                die "unexpected http code $load_code saving to ag-storage-api"
                ;;
        esac
        ;;
    *)
        die "unexpected http code $load_code loading from ag-storage-api"
        ;;
esac


exec -- "$@"
