from . import port

class StateMachine:
    """
    The state machine serves as the controller for the Finite State Machine.

    The StateMachine layer primarily manages transitioning (and locking) of
    the particular states attached to a port. In short, each port will have a
    state machine attached to it (most likely the same) however will have its
    states managed independantly.
    """
    def __init__(self):
        self.ports = {} # Ports have a state attached to them

    def add_port(self, label, port_number=None, socket=None, device_name=None,
        device_type=None, device_mac=None):
        self.ports[port.Port(port_number, socket, device_name, device_type,
            device_mac)] = State(label)

    def get_state(self, port_name):
        return self.ports[port_name]

    def change_state(self, port_number, new_state):
        for p in self.ports:
            if p.port_number == port_number:
                self.ports[p] = new_state

class State:
    """
    Currently a barebones element with only the name as a parameter.

    The purpose of spinning out the state as a seperate class is due to
    the possibility of future work to implement additional state conditions
    and/or metadata.

    Extra logic can be implemented to generate a procedure for the workflow.
    Current the stages have yet to be comepletely designed and thus has been
    omitted for the time being.
    """
    def __init__(self, label):
        self._label = label

    @property
    def label(self):
        return self._label
    @label.setter
    def label(self, value):
        self._label = value
    @label.deleter
    def label(self):
        del self._label
