"""
logic models utilities for interacting with with models, errors, etc
"""
from typing import Optional

from ..ngcs import models


class NotFoundException(BaseException):
    pass


def find_firewall_service(services: models.List[models.FirewallService], name: Optional[str] = None) -> models.FirewallService:
    for service in services:
        if name is not None and name != service.name:
            continue
        return service
    raise NotFoundException


def find_firewall_zone(zones: models.List[models.FirewallZone], name: Optional[str] = None) -> models.FirewallZone:
    for zone in zones:
        if name is not None and name != zone.name:
            continue
        return zone
    raise NotFoundException


def find_firewall_rule(rules: models.List[models.FirewallRule], service: Optional[str] = None, zone: Optional[str] = None) -> models.FirewallRule:
    for rule in rules:
        if service is not None and service != rule.service:
            continue
        if zone is not None and zone != rule.zone:
            continue
        return rule
    raise NotFoundException
