from central_sdi import authz
from netops.authz import load_session


def restVerbToAuthzVerb(verb):
    """ Map the REST api Verb to the Authz Verb
    """

    verb = verb.lower()
    verb_enum = authz.Verb.UNKNOWN
    if verb == "get":
        verb_enum = authz.Verb.READ
    elif verb == "put":
        verb_enum = authz.Verb.WRITE
    elif verb == "post":
        verb_enum = authz.Verb.CREATE
    elif verb == "delete":
        verb_enum = authz.Verb.DELETE
    elif verb == "exec":
        verb_enum = authz.Verb.EXECUTE
    return verb_enum


def secctxt_from_token(token):
    """Get secret text from the token
    """
    return load_session(token)


def can(token, entity, verb):
    """ Check authorization for each entitiy.
    """
    authz_verb = restVerbToAuthzVerb(verb)
    return authz.main_handler(token, entity, authz_verb)
