"""
Auth: parses the authentication token for a given request.
"""

def get_http_authorization(request):
    """
    get_http_authorization: returns a tuple of the (Token, Credentials)
    when the user is authenticating via a simple auth token, or (Cert, None) when
    authenticating via an SSL certificate.
    """
    if request.env.get('SSL_CLIENT_VERIFY') == "SUCCESS":
        return "Cert", None

    if request.get_header("Token") is not None:
        return "Token", request.get_header("Token")

    if request.auth is None:
        return None, None

    http_auth_trimmed = request.auth.strip()

    components = http_auth_trimmed.split()
    if len(components) != 2:
        # not valid authorization header
        return None, None
    req_scheme, req_cred = components

    if req_scheme == "Token":
        return "Token", req_cred
    return None, None
