"""
This module generates the OpenAPI spec for the Falcon API
"""
import re
import falcon.constants
import apispec.core
from falcon_apispec import FalconPlugin
from apispec import APISpec
from apispec.ext.marshmallow import MarshmallowPlugin
from central_ag.api import (
    router,
    schema,
)

# stop it complaining about the methods falcon supports but the codegen tool doesn't
falcon.constants.COMBINED_METHODS = [v.upper() for v in apispec.core.VALID_METHODS_OPENAPI_V3]

app = falcon.App()
falcon_plugin = FalconPlugin(app)
marshmallow_plugin = MarshmallowPlugin()
spec = APISpec(
    title='Automation Gateway',
    version='0.0.0',
    openapi_version='3.0.0',
    plugins=[
        falcon_plugin,
        marshmallow_plugin,
    ],
)

for k, v in schema.field_mapping.items():
    marshmallow_plugin.converter.map_to_openapi_type(*v)(k)

for k, v in schema.schema_mapping.items():
    spec.components.schema(k, schema=v)

root = router.Root()
root.register(app)
for path, resource in root.routes.items():
    spec.path(resource=resource)

if __name__ == "__main__":
    with open(f"{re.sub('[- ]', '_', spec.title.lower())}_{spec.version}.yaml", "w") as f:
        f.write(spec.to_yaml())
