#!/usr/bin/env bash

# USAGE:
# rclone-copy.sh REMOTE_HOST REMOTE_USER KEY_PATH DISABLE_HASH REMOTE_DIR LOCAL_PATHS...

remote_host="$1" \
&& shift \
&& remote_user="$1" \
&& shift \
&& key_path="$1" \
&& shift \
&& disable_hash="$1" \
&& shift \
&& remote_dir="$1" \
&& shift \
&& local_dir="$( mktemp -d )" \
|| exit 1

function cleanup {
    exit_code="$?"
    trap - EXIT
    rm -rf "$local_dir"
    exit "$exit_code"
}
trap cleanup EXIT HUP INT QUIT PIPE TERM

ln -sf -- "$@" "$local_dir/" \
&& rclone -vL copy --sftp-host="$remote_host" --sftp-user="$remote_user" --sftp-key-file="$key_path" --sftp-disable-hashcheck="$disable_hash" "$local_dir" :sftp:"$remote_dir"
