from . import routes


class RequestHandler():
    """
    Generic handler for requests.
    """
    def __init__(self):
        self._content_type = ""
        self._contents = ""
        self._status = ""

    @property
    def contents(self):
        return self._contents
    @contents.setter
    def contents(self, value):
        self._contents = value
    @contents.deleter
    def contents(self):
        del self._contents

    @property
    def content_type(self):
        return self._content_type
    @content_type.setter
    def content_type(self, value):
        self._content_type = value
    @content_type.deleter
    def content_type(self):
        del self._content_type

    @property
    def status(self):
        return self._status
    @status.setter
    def status(self, value):
        self._status = value
    @status.deleter
    def status(self):
        del self._status


class BadRequestHandler(RequestHandler):
    """
    Generic, templated TemplateHandler for quick reference for failed/invalid
    API requests.
    """
    def __init__(self):
        super().__init__()
        self.content_type = 'text/plain'
        self.status = 404


class TemplateHandler(RequestHandler):
    """
    Generic handler to handle requests.
    Has access to the database but should only perform read actions with
    standard use.
    """
    def __init__(self, database):
        super().__init__()
        self.content_type = 'text/html'
        self.database = database

    def check(self, route, method):
        exists, _, _ = routes.check_route(route, method)
        if exists:
            self.status = 200
            return True
        self.status = 404
        return False

    def get_route(self, route, method, data=""):
        _, route, var = routes.check_route(route, method)
        if method == "POST":
            http_routes = routes.routes_POST
        else:
            http_routes = routes.routes_GET
        try:
            if data != '':
                self.contents = http_routes[route]['handler'](var,
                    self.database, data)
            elif var != '':
                self.contents = http_routes[route]['handler'](var,
                    self.database)
            else:
                self.contents = http_routes[route]['handler'](self.database)
        except TypeError:
            self.contents = http_routes[route]['handler']
        return self.contents