from typing import (
    Dict,
)


class Group:
    """
    Represents a Lighthouse Group object as retrieved by the LH REST API.
    """

    def __init__(self, data: Dict):
        self._id = data.get("id")
        self._groupname = data.get("groupname")
        self._description = data.get("description")
        self._enabled = data.get("enabled")
        self._mode = data.get("mode")
        self._smart_group = data.get("smart_group")
        self._smart_group_roles = data.get("smart_group_roles")
        self._managed_device_filter = data.get("managed_device_filter")
        self._members = data.get("members")
        self._global_roles = data.get("global_roles")
        self._last_updated_time = data.get("last_updated_time")
        self._rights = data.get("rights")

    @property
    def id(self):
        return self._id

    @property
    def groupname(self):
        return self._groupname

    @property
    def description(self):
        return self._description

    @property
    def enabled(self):
        return self._enabled

    @property
    def mode(self):
        return self._mode

    @property
    def smart_group(self):
        return self._smart_group

    @property
    def smart_group_roles(self):
        return self._smart_group_roles

    @property
    def managed_device_filter(self):
        return self._managed_device_filter

    @property
    def members(self):
        return self._members

    @property
    def global_roles(self):
        return self._global_roles

    @property
    def last_updated_time(self):
        return self._last_updated_time

    @property
    def rights(self):
        return self._rights
