"""
This module generates the OpenAPI spec for the Falcon API
"""
import re
import falcon.constants
import apispec.core
from falcon_apispec import FalconPlugin
from apispec import APISpec
from apispec.ext.marshmallow import MarshmallowPlugin
from central_sdi.api import router, schema

# stop it complaining about the methods falcon supports but the codegen tool doesn't
falcon.constants.COMBINED_METHODS = [v.upper() for v in apispec.core.VALID_METHODS_OPENAPI_V3]

app = falcon.App()

spec = APISpec(
    title='Software-Defined Infrastructure',
    version='2.1.0',
    openapi_version='3.0.0',
    plugins=[
        FalconPlugin(app),
        MarshmallowPlugin(),
    ],
)

for k, v in schema.schemas.items():
    spec.components.schema(k, schema=v)

root = router.Root()
root.register_routes(app)

for route, properties in root.routes.items():
    spec.path(resource=properties.get('handler'))

if __name__ == "__main__":
    with open(f"{re.sub('[- ]', '_', spec.title.lower())}_{spec.version}.yaml", "w") as f:
        f.write(spec.to_yaml())
