"""
api: initialises the Falcon rest api, basically wrapping the other setup classes.
"""
import logging
import falcon
import sys

from falcon_marshmallow import Marshmallow
from netops.grpcutil import (
    service as grpcsvc,
)
from netops import (
    auth as nom_auth,
    authz
)
from central_sdi.api import auth, errors, media_handler, router

extra_handlers = {
    'text/plain': media_handler.PLAINTEXTHandler(),
    'application/zip': media_handler.ZipHandler()
}

# init services
nom_auth_channel = grpcsvc.MiddlewareChannel(authz.grpc_channel)
nom_auth_adapter = nom_auth.AdapterStub(nom_auth_channel)

app = application = falcon.App(middleware=[
    nom_auth_channel,
    auth.AuthenticationMiddleware(),
    Marshmallow()])

root = router.Root(nom_auth_stub=nom_auth_adapter)
root.register_routes(app)

app.add_error_handler(falcon.errors.HTTPNotFound, errors.not_found)
app.add_error_handler(falcon.errors.HTTPMethodNotAllowed, errors.not_supported)
app.add_error_handler(falcon.errors.HTTPUnprocessableEntity, errors.unprocessable_entity)

# https://falcon.readthedocs.io/en/stable/api/media.html - reference used for adding a new media handler
app.resp_options.media_handlers.update(extra_handlers) # pylint: disable=no-member
app.req_options.media_handlers.update(extra_handlers)  # pylint: disable=no-member

logging.basicConfig(stream=sys.stderr, level=logging.INFO)
