from marshmallow import Schema, fields, validate


### Device Resource Schemas ###

class Enrollment(Schema):
    bundle = fields.String()
    port = fields.String(validate=validate.Range(min=1, max=65535))
    token = fields.String()
    url = fields.String()


class DeviceResource(Schema):
    config_file = fields.String()
    device_type = fields.String()
    distribution = fields.List(fields.String())
    enrollment = fields.Nested(Enrollment)
    image_file = fields.String()
    mac_address = fields.List(fields.String())
    model = fields.String()
    name = fields.String()
    post_provision_script = fields.String()
    provision_after = fields.List(fields.String())
    script_file = fields.String()
    serial_number = fields.List(fields.String())


class DeviceResourceList(Schema):
    device_resources = fields.List(fields.Nested(DeviceResource))


class DeviceResourceFiles(Schema):
    downloads = fields.List(fields.String())
    scripts = fields.List(fields.String())


### Inventory Schemas ###

class NodeInventory(Schema):
    distribution = fields.List(fields.String(), required=True)
    name = fields.String(required=True)
    static = fields.List(fields.String())
    smartgroup = fields.String()


class NodeInventoryList(Schema):
    node_inventories: fields.List(fields.Nested(NodeInventory))


class Push(Schema):
    status = fields.String()


class Sync(Schema):
    status = fields.String()


class SmartgroupList(Schema):
    smartgroups = fields.List(fields.String())


class Config(Schema):
    ipaddress = fields.String()
    subnet_mask = fields.String()


class SSHKey(Schema):
    id = fields.String()
    public_key = fields.String()
    fingerprint = fields.String()
    name = fields.String()


class SSHKeyList(Schema):
    ssh_keys = fields.List(fields.Nested(SSHKey))


# All the schemas are enumerated here so they can be added to the API Spec
schemas = {
    'Enrollment': Enrollment,
    'DeviceResource': DeviceResource,
    'DeviceResourceList': DeviceResourceList,
    'DeviceResourceFiles': DeviceResourceFiles,
    'NodeInventory': NodeInventory,
    'NodeInventoryList': NodeInventoryList,
    'Push': Push,
    'Sync': Sync,
    'SmartgroupList': SmartgroupList,
    'Config': Config,
    'SSHKey': SSHKey,
    'SSHKeyList': SSHKeyList,
}
