"""
api is the entrypoint used by uwsgi
"""

import os
import logging
import sys
import grpc
import falcon
import falcon_marshmallow
from typing import (
    Dict,
    List,
)
from central_ag.api import (
    auth,
    router,
    util,
)
from netops.lighthouse import (
    nodes as lh_nodes,
)
from netops import (
    automation_gateway as ag,
)
from netops.automation_gateway import (
    job,
)
from netops.grpcutil import (
    service as grpcsvc,
)

logging.basicConfig(stream=sys.stderr, level=logging.INFO)

# init services
ag_auth_channel = grpcsvc.MiddlewareChannel(
    lambda: grpc.insecure_channel('ag-auth:9046'))
ag_auth = ag.AuthStub(ag_auth_channel)
ag_devices_channel = grpcsvc.MiddlewareChannel(
    lambda: grpc.insecure_channel('ag-devices:9047'))
ag_devices = ag.DevicesStub(ag_devices_channel)
ag_nmap_scan = job.NmapScanStub(ag_devices_channel)
identity = auth.Identity()


def get_nodes(token: str, nodes: List[str]) -> Dict[str, lh_nodes.Node]:
    return util.get_nodes(os.getenv('APP_LIGHTHOUSE_HOST'), nodes, token, os.getenv('APP_LIGHTHOUSE_INSECURE') != 'true')


# init application
app = application = falcon.App(middleware=[
    ag_auth_channel,
    ag_devices_channel,
    falcon_marshmallow.Marshmallow(),
    auth.Middleware(identity=identity),
])
root = router.Root(
    identity=identity,
    ag_auth=ag_auth,
    ag_devices=ag_devices,
    ag_nmap_scan=ag_nmap_scan,
    get_nodes=get_nodes,
)
root.register(app)
