"""
Authz: implements the authorization methods for libogauthz.
"""
from central_dop import authz
from netops.authz import load_session


def restVerbToAuthzVerb(verb):
    """
    restVerbToAuthzVerb: convert a verb to an enum for comparison.
    """
    verb = verb.lower()
    verb_enum = authz.Verb.UNKNOWN
    if verb == "get":
        verb_enum = authz.Verb.READ
    elif verb == "put":
        verb_enum = authz.Verb.WRITE
    elif verb == "post":
        verb_enum = authz.Verb.CREATE
    elif verb == "delete":
        verb_enum = authz.Verb.DELETE
    elif verb == "exec":
        verb_enum = authz.Verb.EXECUTE

    return verb_enum


def secctxt_from_token(token):
    """
    secctxt_from_token: convert a token to a secctxt.
    """
    return load_session(token)


def can(token, entity, verb):
    """
    can: resolves if a given token has requested access to a given resource.
    """
    authz_verb = restVerbToAuthzVerb(verb)
    return authz.main_handler(token, entity, authz_verb)
