class Port:
    """
    The purpose of this class is to track the current status of ports.

    In order to correctly manage the state of the port, locking mechanisms
    will be required to allow only a single host to edit the information at a
    time. Ports are the top level layer with state machines attached to them.
    """
    # pylint: disable=too-many-instance-attributes
    def __init__(self, port_id=None, device_type=None, label=None,
        baud=None, pinout=None, mac_address=None, serial_no=None,
        factory_default=None, discovery_username=None, discovery_password=None):
        # pylint: disable=too-many-arguments
        self._port_id = port_id
        self._device_type = device_type
        self._label = label
        self._baud = baud
        self._pinout = pinout
        self._mac_address = mac_address
        self._serial_no = serial_no
        self._factory_default = factory_default
        self._discovery_username = discovery_username
        self._discovery_password = discovery_password

    @property
    def port_id(self):
        return self._port_id
    @port_id.setter
    def port_id(self, value):
        self._port_id = value
    @port_id.deleter
    def port_id(self):
        del self._port_id

    @property
    def device_type(self):
        return self._device_type
    @device_type.setter
    def device_type(self, value):
        self._device_type = value
    @device_type.deleter
    def device_type(self):
        del self._device_type

    @property
    def label(self):
        return self._label
    @label.setter
    def label(self, value):
        self._label = value
    @label.deleter
    def label(self):
        del self._label

    @property
    def baud(self):
        return self._baud
    @baud.setter
    def baud(self, value):
        self._baud = value
    @baud.deleter
    def baud(self):
        del self._baud

    @property
    def pinout(self):
        return self._pinout
    @pinout.setter
    def pinout(self, value):
        self._pinout = value
    @pinout.deleter
    def pinout(self):
        del self._pinout

    @property
    def mac_address(self):
        return self._mac_address
    @mac_address.setter
    def mac_address(self, value):
        self._mac_address = value
    @mac_address.deleter
    def mac_address(self):
        del self._mac_address

    @property
    def serial_no(self):
        return self._serial_no
    @serial_no.setter
    def serial_no(self, value):
        self._serial_no = value
    @serial_no.deleter
    def serial_no(self):
        del self._serial_no

    @property
    def factory_default(self):
        return self._factory_default
    @factory_default.setter
    def factory_default(self, value):
        self._factory_default = value
    @factory_default.deleter
    def factory_default(self):
        del self._factory_default

    @property
    def discovery_username(self):
        return self._discovery_username
    @discovery_username.setter
    def discovery_username(self, value):
        self._discovery_username = value
    @discovery_username.deleter
    def discovery_username(self):
        del self._discovery_username

    @property
    def discovery_password(self):
        return self._discovery_password
    @discovery_password.setter
    def discovery_password(self, value):
        self._discovery_password = value
    @discovery_password.deleter
    def discovery_password(self):
        del self._discovery_password

    def formatted_data(self):
        """
        Return data as a dict with JSON structure.
        """
        formatted_data = \
        {
            "port_id": self._port_id,
            "device_type": self._device_type,
            "label": self._label,
            "baud": self._baud,
            "pinout": self._pinout,
            "mac_address": self._mac_address,
            "serial_no": self._serial_no,
            "factory_default": self._factory_default,
            "discovery_username": self._discovery_username,
            "discovery_password": self._discovery_password
        }
        return formatted_data

    def write_from_data(self, data_map):
        """
        Write the JSONified data into the database for a single port if all
        parameters/keys are present and valid.
        """
        if all(key in data_map for key in self.formatted_data()):
            try:
                self.port_id = data_map["port_id"]
                self.device_type = data_map["device_type"]
                self.label = data_map["label"]
                self.baud = data_map["baud"]
                self.pinout = data_map["pinout"]
                self.mac_address = data_map["mac_address"]
                self.serial_no = data_map["serial_no"]
                self.factory_default = data_map["factory_default"]
                self.discovery_username = data_map["discovery_username"]
                self.discovery_password = data_map["discovery_password"]
                return True
            except ValueError:
                pass
        return False
