from io import RawIOBase

class IterableStream(RawIOBase):
    """
    IterableStream wraps an iterable to implement raw io for python's stream api

    Can be used like:  io.BufferedReader(IterableStream(iterable), buffer_size=io.DEFAULT_BUFFER_SIZE)

    Modified from example at https://stackoverflow.com/a/20260030
    """

    def __init__(self, iterable):
        super().__init__()
        self._iterable = iterable
        self._leftover = None

    @property
    def iterable(self):
        return self._iterable

    @property
    def leftover(self):
        return self._leftover

    def readable(self):
        return True

    def readinto(self, b):
        try:
            chunk = self._leftover
            while not chunk:
                chunk = next(self._iterable)
            output, self._leftover = chunk[:len(b)], chunk[len(b):]
            b[:len(output)] = output
            return len(output)
        except StopIteration:
            return 0
