import marshmallow
from marshmallow import (
    fields,
    validate,
)

# deploy_status_in_progress indicates to lighthouse that a deploy is currently
# running
deploy_status_in_progress = "in_progress"
# deploy_status_complete indicates to lighthouse that a deploy completed
# successfully
deploy_status_complete = "complete"
# deploy_status_unsupported indicates to lighthouse that one or more nodes
# were not a supported type
deploy_status_unsupported = "unsupported"
# deploy_status_fail indicates to lighthouse that the deploy failed
deploy_status_fail = "fail"
# deploy_status_unknown indicates to lighthouse that the deploy failed
deploy_status_unknown = "unknown"

# deploy_statuses list all the possible deploy statuses and are used to power
# (a hack) behavior that matches "deploy ids" against known statuses, which
# will escape any checking of files and simply return that status if so
deploy_statuses = [
    deploy_status_in_progress,
    deploy_status_complete,
    deploy_status_unsupported,
    deploy_status_fail,
    deploy_status_unknown,
]


class Message(marshmallow.Schema):
    message = fields.String(required=True)


class Error(marshmallow.Schema):
    error = fields.String(required=True)


class AvailableModule(marshmallow.Schema):
    id = fields.String()


class AvailableModules(marshmallow.Schema):
    netops_modules = fields.Nested(AvailableModule, data_key='netops-modules', many=True)


class DeployRequest(marshmallow.Schema):
    module = fields.String(required=True)
    nodes = fields.List(fields.String(), required=True)
    deploy_central = fields.Boolean(default=True)


class DeployResponse(marshmallow.Schema):
    id = fields.String(required=True)


class DeployStatus(marshmallow.Schema):
    status = fields.String(
        required=True,
        validate=validate.ContainsOnly(choices=deploy_statuses),
    )

class StateStatus(marshmallow.Schema):
    status = fields.String(
        required=True,
        validate=validate.ContainsOnly(choices=deploy_statuses),
    )
    error_message = fields.String(required=True)


class State(marshmallow.Schema):
    pass
    # TODO: parse deployment.netops.proto and use those types to generate this
    # https://gist.github.com/trianta2/fd04bdbfc9bdef5631c0d76582a04aca

schemas = {
    'Message': Message,
    'Error': Error,
    'AvailableModule': AvailableModule,
    'AvailableModules': AvailableModules,
    'DeployRequest': DeployRequest,
    'DeployResponse': DeployResponse,
    'DeployStatus': DeployStatus,
    'StateStatus': StateStatus,
}
