import subprocess
import grpc
from central_sdi import util
from netops.ip_access import remote


def disconnect(logger, conn, cache):
    """
    disconnect: implements the openvpn client disconnect script hook
    """
    sdi_header = util.log_header(conn.node_id, conn.username)
    try:
        if conn.teardown_commands is not None:
            for command in conn.teardown_commands:
                # note check is not set, this won't fail on non-zero exit codes
                subprocess.run(command, check=False, timeout=60)
        if conn.client_mac is not None:
            cache.cancel_reservation(conn.client_mac)
    finally:
        _disconnect_remote(
            node_ip=conn.node_ip,
            node_port=conn.node_port,
            session_id=conn.session_id,
        )
    logger.info(f'{sdi_header} VPN client disconnected')


def _disconnect_remote(node_ip, node_port, session_id):
    with grpc.insecure_channel(f"{node_ip}:{node_port}") as channel:
        remote.SessionsStub(channel).Disconnect(remote.SessionsDisconnectRequest(session_id=session_id))
        remote.SessionsStub(channel).Delete(remote.SessionsDeleteRequest(session_id=session_id))
