"""
util contains random more general implementations
"""


def netmask_cidr(netmask: str) -> int:
    """
    returns the cidr value like "24" from a netmask like "255.255.255.0"
    raises a ValueError if the netmask is invalid
    """
    cidr = 0
    fragments = netmask.split('.')
    if len(fragments) != 4:
        raise ValueError('invalid netmask (reason: fragments count): {}'.format(netmask))
    zero = False
    for fragment in fragments:
        if not fragment.isdigit():
            raise ValueError('invalid netmask (reason: fragment format): {}'.format(netmask))
        fragment = int(fragment)
        if fragment < 0 or fragment > 255:
            raise ValueError('invalid netmask (reason: fragment size): {}'.format(netmask))
        bits = format(fragment, 'b').zfill(8)
        for bit in bits:
            if bit == '0':
                zero = True
            elif zero:
                raise ValueError('invalid netmask (reason: bit format): {}'.format(netmask))
            else:
                cidr += 1
    return cidr
