"""
header has standard-ish http header aliases
"""

import datetime
import grpc
from typing import (
    Tuple,
)


def last_modified(timestamp: int) -> Tuple[str, str]:
    """
    last_modified converts a last modified timestamp as a unix ns epoch to a header kv tuple
    """
    return 'Last-Modified', datetime.datetime.utcfromtimestamp(timestamp / 1000000000).strftime('%a, %d %b %Y %H:%M:%S GMT')


def grpc_status(code: grpc.StatusCode) -> Tuple[str, str]:
    """
    grpc_status converts a grpc.StatusCode into a header kv tuple
    """
    return 'Grpc-Status', str(code.value[0])
