# globals: Awful global state for use with openvpn script hooks.
#
# DO NOT USE IN THE API

import json
import logging
import logging.handlers
import os

import sys

from . import sessions, util


class Env:
    # logger.getLogger()
    logger = None
    # sessions.Cache
    cache = None
    # lighthouse lhvpn address
    lighthouse_ip = None
    # sdi bridge interface name
    bridge_iface = None
    # connect timestamp of the current connection (client to openvpn)
    time_unix = None
    # get and set a connection in cache for time_unix
    connection = None
    # get and set json encode-able data pertaining to the last auth
    last_auth = None
    # tcp port on the remote node where the remote api is being served
    node_port = None


env = Env()


def init():
    logging.basicConfig(stream=sys.stderr, level=logging.INFO)
    syslog_handler = logging.handlers.SysLogHandler(address=('localhost', 514))
    syslog_formatter = logging.Formatter('1 - - central-sdi - - - %(message)s')
    syslog_handler.setFormatter(syslog_formatter)
    logger = logging.getLogger()
    logger.addHandler(syslog_handler)
    Env.logger = logger

    Env.cache = sessions.Cache(cache_dir=os.environ.get("CACHE_DIR"))

    lighthouse_ip = None

    def get_lighthouse_ip(self): # pylint: disable=unused-argument
        nonlocal lighthouse_ip
        if lighthouse_ip is None:
            lighthouse_ip = util.get_lhvpn_address()
        return lighthouse_ip

    Env.lighthouse_ip = property(get_lighthouse_ip)

    Env.bridge_iface = os.environ.get("SDI_BRIDGE")

    time_unix = None

    def get_time_unix(self): # pylint: disable=unused-argument
        nonlocal time_unix
        if time_unix is None:
            time_unix = os.environ.get("time_unix")
            if time_unix is None:
                raise ValueError('time_unix is not set')
            time_unix = str(int(time_unix))
        return time_unix

    Env.time_unix = property(get_time_unix)

    def get_connection(self):
        v = self.time_unix
        connection = self.cache.load(v)
        if connection is not None:
            if not isinstance(connection, sessions.Connection):
                raise ValueError(f'unexpected connection type: {connection}')
            if connection.time_unix != v:
                raise ValueError(f'unexpected connection.time_unix: {connection.time_unix}')
        return connection

    def set_connection(self, connection):
        v = self.time_unix
        if not isinstance(connection, sessions.Connection):
            raise ValueError(f'unexpected connection type: {connection}')
        if connection.time_unix != v:
            raise ValueError(f'unexpected connection.time_unix: {connection.time_unix}')
        self.cache.store(connection)

    Env.connection = property(get_connection, set_connection)

    last_auth_path = os.environ.get("AUTH_FILE")
    if not last_auth_path:
        raise ValueError('AUTH_FILE not set')

    def load_last_auth():
        nonlocal last_auth_path
        try:
            with open(last_auth_path, "r") as f:
                return json.load(f)
        except FileNotFoundError:
            return None

    def store_last_auth(args):
        nonlocal last_auth_path
        with open(last_auth_path, "w") as f:
            json.dump(args, f)

    Env.last_auth = property(lambda self: load_last_auth(), lambda self, args: store_last_auth(args))

    Env.node_port = '8980'
