#!/usr/bin/env bash

set -o pipefail

die() { echo FATAL "$@" >&2; exit 1; }

local_files="$( server_ensure.sh )" \
&& readarray -t local_files <<< "$local_files" \
&& [ "${#local_files[@]}" -gt 0 ] \
|| die "failed to validate local files"

do_save() { for i in {1..3}; do timeout -- 90 curl -s -f -X POST --data-binary "@$1" "$2" >/dev/null && return 0 || sleep 3; done; return 1; }

for local_file in "${local_files[@]}"; do
    if [ "${local_file:0:${#CA_DIR}}" = "$CA_DIR" ]; then
        remote_file="ca${local_file:${#CA_DIR}}"
    elif [ "${local_file:0:${#VPN_DIR}}" = "$VPN_DIR" ]; then
        remote_file="vpn${local_file:${#VPN_DIR}}"
    else
        die "unexpected local file ${local_file}"
    fi
    do_save "${local_file}" "${STORAGE_API_ADDR}/${remote_file}" \
    || die "failed to save ${local_file} to ${STORAGE_API_ADDR}/${remote_file}"
done
