#!/usr/bin/env bash

set -o pipefail

die() { echo FATAL "$@" >&2; exit 1; }

server_dirs.sh \
|| exit "$?"

if [ ! -f "$VPN_DIR/dh2048.pem" ]; then
    openssl dhparam -out "$VPN_DIR/dh2048.pem" "$DH_BITS" \
    || die "failed to init server ssl dh2048.pem"
fi

for config_file in "$CA_DIR/ca."{key,csr}; do
    if [ -f "$config_file" ]; then
        continue
    fi
    rm -rf \
        "$CA_DIR/ca."{key,csr} \
        "$CA_DIR/ca.crt" \
    && openssl req \
        -nodes \
        -new \
        -newkey rsa \
        -keyout "$CA_DIR/ca.key" \
        -out "$CA_DIR/ca.csr" \
        -subj "$CA_SUBJ" \
    && break \
    || die "failed to init ca key"
done

for config_file in "$VPN_DIR/server."{key,csr}; do
    if [ -f "$config_file" ]; then
        continue
    fi
    rm -rf \
        "$VPN_DIR/server."{key,csr} \
        "$VPN_DIR/server.crt" \
    && openssl req \
        -nodes \
        -new \
        -newkey rsa \
        -keyout "$VPN_DIR/server.key" \
        -out "$VPN_DIR/server.csr" \
        -subj "${VPN_SUBJ}" \
    && break \
    || die "failed to init server key"
done

if [ ! -f "$CA_DIR/ca.crt" ] \
        || [ ! -f "$CA_DIR/ca.crl" ] \
        || [ ! -f "$CA_DIR/ca.srl" ] \
        || [ ! -f "$CA_DIR/index.txt" ]; then
    rm -rf \
        "$CA_DIR/ca.crt" \
        "$CA_DIR/ca.crl" \
        "$CA_DIR/ca.srl" \
        "$CA_DIR/index.txt" \
        "$VPN_DIR/server.crt" \
    && tee "$CA_DIR/ca.srl" >/dev/null <<<"01" \
    && tee "$CA_DIR/index.txt" >/dev/null </dev/null \
    && openssl ca \
        -batch \
        -selfsign \
        -extensions v3_ca \
        -days "$CA_DAYS" \
        -in "$CA_DIR/ca.csr" \
        -out "$CA_DIR/ca.crt" \
    || die "failed to init server ca cert"
fi

if [ ! -f "$CA_DIR/ca.crl" ]; then
    openssl ca \
        -gencrl \
        -crldays "$CA_DAYS" \
        -out "$CA_DIR/ca.crl" \
    || die "failed to init server ca crl"
fi

if [ ! -f "$VPN_DIR/server.crt" ]; then
    openssl ca \
        -batch \
        -extensions v3_server \
        -days "$CA_DAYS" \
        -in "$VPN_DIR/server.csr" \
        -out "$VPN_DIR/server.crt" \
    || die "failed to init server cert"
fi

exec -- server_ensure.sh >/dev/null
