#!/usr/bin/env bash

# ensures the existence of directories used by the server scripts

die() { echo FATAL "$@" >&2; exit 1; }

init_dirs=(
    "$VPN_DIR"
    "$CA_DIR"
    "$CA_DIR/certs"
    "$CACHE_DIR"
    "$CACHE_DIR/sessions"
    "$CACHE_DIR/addresses"
) \
&& mkdir -p -- "${init_dirs[@]}" \
&& chmod 755 -- "${init_dirs[@]}" \
|| die "directory init error"
