#!/usr/bin/env bash

die() { echo FATAL "$@" >&2; exit 1; }

# load server config from the storage api
server_load.sh
case "$?" in
    0)
        # found and loaded successfully from the storage api
        exit 0
        ;;
    3)
        # only partially found in the storage api, or it synced successfully but failed validation, or for some
        # unexpected reason the local state failed validation after copying
        ;;
    4)
        # not found in the storage api
        ;;
    *)
        die "unexpected error loading server config"
        ;;
esac

# either the local configuration looks ok or we need to make it that way
# in either case, we then need to save it into the storage api
{ server_ensure.sh >/dev/null || server_init.sh; } \
&& server_save.sh \
|| die "failed to configure server"
