#!/usr/bin/env bash

# TODO most of this script needs to be rewritten to add error handling and general sanity

die() { echo FATAL "$@" >&2; exit 1; }

set -o pipefail || die "failed to configure bash options"

# check the existence of required env vars
#
# NOTE env variables must ALSO be explicitly passed down / made available to openvpn hooks, see the supervisord config
for k in \
    LH_ADDR \
    DH_BITS \
    STORAGE_API_ADDR \
    SDI_SUBNET \
    SDI_BRIDGE \
    CA_DIR \
    CACHE_DIR \
    AUTH_FILE \
    MGMT_SOCKET \
    CA_DAYS \
    VPN_DIR \
    VPN_DAYS \
    CA_SUBJ \
    VPN_SUBJ
do
    [ ! -z "${!k}" ] || die "$k not set"
done

cleanup_paths=( "$CACHE_DIR" "$AUTH_FILE" ) \
&& rm -rf "${cleanup_paths[@]}" \
|| die "filesystem cleanup error"

{ ip link del "$SDI_BRIDGE" 2>/dev/null || true; } \
&& ip link add name "$SDI_BRIDGE" type bridge \
&& ip link set "$SDI_BRIDGE" up \
|| die "bridge init error"

ebtables -I FORWARD --logical-in "$SDI_BRIDGE" -j DROP \
&& ebtables -I FORWARD --logical-out "$SDI_BRIDGE" -j DROP \
&& while ebtables -D FORWARD --logical-in "$SDI_BRIDGE" -j IpAccessForward 2>/dev/null; do true; done \
&& while ebtables -D FORWARD --logical-out "$SDI_BRIDGE" -j IpAccessForward 2>/dev/null; do true; done \
&& { ebtables -F IpAccessForward 2>/dev/null \
    && ebtables -X IpAccessForward \
    || true; } \
&& ebtables -N IpAccessForward >/dev/null 2>&1 \
&& ebtables -A IpAccessForward -j DROP \
&& ebtables -I FORWARD --logical-in "$SDI_BRIDGE" -j IpAccessForward \
&& ebtables -I FORWARD --logical-out "$SDI_BRIDGE" -j IpAccessForward \
&& while ebtables -D FORWARD --logical-in "$SDI_BRIDGE" -j DROP 2>/dev/null; do true; done \
&& while ebtables -D FORWARD --logical-out "$SDI_BRIDGE" -j DROP 2>/dev/null; do true; done \
|| die "ebtables init error"

server_configure.sh || exit 1

exec -- "$@"
