"""
router: Initialisation stage for the API to register all route/path/handler
combinations for the supported REST api endpoints and versions.
"""
from deployment.api import modules

routes = {
    '/': {"handler": modules.Modules()},
    '/deploy': {"handler": modules.Deploy()},
    '/deploy/{deploy_id}': {"handler": modules.Status()},
    '/cleanup': {"handler": modules.Cleanup()},
    '/status': {"handler": modules.StateStatus()},
    '/state': {"handler": modules.State()},
}


def register_routes(api):
    """
    register_routes: traverse the routes table and register each path with the
    handler.
    """
    for route, properties in routes.items():
        api.add_route(route, properties.get('handler'))
