"""
node_cfg handles IPAccess configuration for nodes, currently backed by a JSON file in the
storage API.
"""
import json
from central_sdi import storage_api

nodes_cfg_file = 'nodescfg'


def nodes_cfg_load():
    """
    Fetch IPAccess nodes config

    # TODO not sure if we need to handle migrating old ip_access_store config
    # TODO could we even avoid a central config file altogether, if we can pull
    # config from the remote node APIs a la Lighthouse config retrieval?
    """
    nodes_cfg = NodesConfig()
    try:
        for node in json.load(storage_api.sa_load(nodes_cfg_file)):
            nodes_cfg.add_node_cfg(NodeConfig(node['node_id'], node['disabled']))
    except storage_api.ObjectNotFound:
        pass
    return nodes_cfg


def nodes_cfg_store(cfg):
    """
    Update IPAccess nodes config
    """
    storage_api.sa_store(nodes_cfg_file, json.dumps(cfg.to_dict()))


class NodeConfig:
    def __init__(self, node_id, disabled=False):
        self._node_id = node_id
        self._disabled = disabled

    @property
    def node_id(self):
        return self._node_id

    @property
    def disabled(self):
        return self._disabled

    @disabled.setter
    def disabled(self, disabled):
        self._disabled = disabled

    def to_dict(self):
        return {
            'node_id': self.node_id,
            'disabled': self.disabled
        }


class NodesConfig:
    def __init__(self):
        self._node_cfgs = []

    @property
    def node_cfgs(self):
        return self._node_cfgs

    def add_node_cfg(self, node_cfg):
        self._node_cfgs.append(node_cfg)

    def get_node_cfg_by_id(self, node_id):
        cfgs = [n for n in self.node_cfgs if n.node_id == node_id]
        # Hopefully only 1 match
        if cfgs:
            return cfgs[0]
        return None

    def to_dict(self):
        ret = [n.to_dict() for n in self.node_cfgs]
        return ret
