"""
util: a module to put functions which can be generally useful across the board.
"""
import re


def strip_between_patterns(start, end, content):
    """
    strip_between_patterns accepts a string, and returns a string excluding the
    section between the start and end pattern (inclusive).

    @start - the start pattern
    @end - the end pattern
    @content - the string to process

    @return - the string excluding the section between the start and end pattern
              and the patterns themselves.
    """

    has_start = False
    has_end = False
    output = []

    for line in content:
        if has_start and not has_end:
            if re.match(end, line):
                has_start = False
                has_end = True
            else:
                continue
        elif re.match(start, line):
            has_start = True
            has_end = False
        elif not has_start:
            if len(line) != 0:  # pylint: disable=len-as-condition
                output.append(line)

    return output