"""
router: Initialisation stage for the API to register all route/path/handler
combinations for the supported REST api endpoints and versions.
"""
from central_dop.api import dop

routes = {
    '/device_resources': {"handler": dop.Resources()},
    '/device_resources/{name}': {"handler": dop.Resource()},
    '/device_resources_files': {"handler": dop.Files()},
    '/routes': {"handler": dop.Routes()},
    '/rights': {"handler": dop.Rights()},
    '/push': {"handler": dop.Push()},
    '/sync': {"handler": dop.Sync()},
    '/node_inventory': {"handler": dop.Inventory()},
    '/node_inventory/{name}': {"handler": dop.InventoryItem()},
    '/smartgroups': {"handler": dop.Smartgroups()},
    '/config': {"handler": dop.Config()},
    '/keys': {"handler": dop.Keys()},
    '/keys/{key}': {"handler": dop.Key()},
}


def register_routes(api):
    """
    register_routes: traverse the routes table and register each path with the
    handler.
    """
    for route, properties in routes.items():
        api.add_route(route, properties.get('handler'))


def auth_required(endpoint):
    """
    auth_required: returns True unless the endpoint object contains a 'no_auth'
    key with the value False. This indicates the endpoint requires no authentication.
    """
    if endpoint not in routes:
        # Should never reach this.
        return False
    return not routes.get(endpoint).get("no_auth")
