""" This module is used to add any utilities which are
    required by the REST API and other scripts.
"""
import os
import requests
import subprocess

# Cache value
api_version = None


def get_host_address():
    """
    returns the address of the host based on the default gateway of the
    underlying docker network (which is currently be the host address)
    """
    route_info = subprocess.check_output(["/sbin/ip", "route", "show", "default"])
    addr = route_info.split()[2].decode("utf-8")
    return addr


def get_api_version():
    """returns the current version of the LH api
    """
    global api_version

    if api_version is None:
        api_version = os.environ.get("LH_API_VERSION")

    # Fallback option is v3.2
    if api_version is None:
        api_version = "v3.2"

    return api_version


def make_request(url, token=None):
    """
    Make an API request and return the response.

    If a token is provided, it will use that. Else it will use cert auth
    with global access.
    """
    if token:
        headers = {"Authorization": "Token {}".format(token)}
        return requests.get(url, verify=False, headers=headers)

    return requests.get(url, verify=False, cert=get_certs())


def get_certs():
    """get_certs returns the ssl public & private keypair for the requests lib
       to use. We can use to access Lighthouse endpoints for internal scripts.
    """
    return "/root/.netops/lhvpn/lhvpn_server.crt", "/root/.netops/lhvpn/lhvpn_server.key"
